<?php

class User {

	private $id;
	private $name;
	private $priviledges;
	private $content;
	private $contactDetails;

	public function __construct() {
		$this->contactDetails = new UserContactDetails();
	}

	function notify($message) {

		$messageBody = 'Dear ' . $this->name;
		$messageBody .= '( ' . $this->contactDetails->getStreetNumber() . ' ' .
				$this->contactDetails->getStreetName() . ').';
		$messageBody .= $message;

		$notificationService->sendSMS($this->contactDetails->getPhoneNubmer(), $messageBody);
	}

	function delete() {
		systemDelete($this->id);
		// system command to delete user with $id
	}

	function update() {
		// system command to update user identified by $id
		// with $priviledges and $content
		systemUpdate($this->id, $this->priviledges, $this->content);
	}

	function restrict() {
		// restric priviledges of a user
		systemRestrictUser($this->id, $this->priviledges);
	}

	function censorContent() {
		// censor user content
		systemCensor($this->id, $this->content);
	}

	public function setPriviledges($priviledges) {
		$this->priviledges = $priviledges;
	}

	public function setContent($content) {
		$this->content = $content;
	}



}

?>
